```json
{
  "title": "Trial Chambers",
  "icon_sprite": "minecraft:icon/trial_chambers",
  "category": "minecraft:structures"
}
```

**Trial chambers** are underground [structures](^minecraft:structures) that serve as a mid-game combat challenge. They consist mostly of [copper](https://minecraft.wiki/w/Copper) blocks and [tuff bricks](^minecraft:tuff_bricks), and are the only place where [trial spawners](^minecraft:trial_spawner) and [vaults](^minecraft:vault) naturally generate. Trial chambers are also the only place where [breeze](^minecraft:breeze) spawn, whose [breeze rods](^minecraft:breeze_rod) can be used to craft [wind charges](^minecraft:wind_charge).

;;;;;

&title(Appearance)
![Trial Chambers](minecraft:textures/gui/image/trial_chambers.png,fit)

;;;;;

Various materials such as [heavy cores](^minecraft:heavy_core) and certain [armor trims](^minecraft:smithing_templates) are obtained exclusively by unlocking vaults in trial chambers.


[Ominous trials](^minecraft:ominous_event) can also take place here through [Bad Omen](^minecraft:bad_omen), where [Trial Omen](^minecraft:trial_omen) can cause all [trial spawners](^minecraft:trial_spawner) to become [ominous](^minecraft:ominous_trial_spawner), making them more difficult and providing greater rewards.

;;;;;

&title(Generation)
[Biomes that Generate Trial Chambers](^minecraft:tag/has_structure/trial_chambers).


Trial chambers generate underground in the [Overworld](^minecraft:overworld). The starting room generates at an [altitude](https://minecraft.wiki/w/Altitude) of between Y = -40 and -20, but the structure is not restricted to those Y levels. In fact, the majority of the structure's rooms tend to generate between Y = -20 and 0.

;;;;;

&title(Generation)
The generation of trial chambers follows a grid of 32×32 [chunk](https://minecraft.wiki/w/Chunk) regions centered on the world origin (X=0, Z=0). There is always one trial chambers structure generated in each region at a random location.

;;;;;

Trial chambers can be located using [trial explorer maps](https://minecraft.wiki/w/Trial_explorer_map), which are sold by journeyman-level [cartographer](https://minecraft.wiki/w/Cartographer) villagers for 12 [emeralds](https://minecraft.wiki/w/Emerald) and a [compass](https://minecraft.wiki/w/Compass). The maps always point to the nearest trial chamber relative to the cartographer.

;;;;;

&title(Structure)
The trial chambers are a procedurally generated [structure](^minecraft:structures) made mainly of [tuff bricks](^minecraft:tuff_bricks), [copper](https://minecraft.wiki/w/Block_of_Copper), and their variants. The chambers consist of a number of different rooms, some of which contain [trial spawners](^minecraft:trial_spawner) and [vaults](^minecraft:vault). Some trial spawners may contain the breeze, a hostile mob that shoots wind charges at the player.

;;;;;

&title(Components)
All trial chambers follow a common structure. A trial chambers structure is composed of 4 main components: hallways, corridors, intersections, and chambers. There is always 1 entrance chamber, which is used as the starting point when the game generates a trial chambers structure.

;;;;;

&title(Entrance)
The entrance chamber generates in every trial chamber and features a 3×3 "doorway" made of oxidized [copper blocks](^minecraft:copper_block), [cut copper](https://minecraft.wiki/w/Cut_copper), and [chiseled copper](^minecraft:chiseled_copper). The room also contains several [chests](https://minecraft.wiki/w/Chest) with entrance loot and at least one [vault](^minecraft:vault). Some of the entrances also have a platform with either a solitary [oak](https://minecraft.wiki/w/Oak_tree) or [mangrove tree](https://minecraft.wiki/w/Mangrove_tree), or a [cactus](https://minecraft.wiki/w/Cactus) with a [dead bush](https://minecraft.wiki/w/Dead_bush).

;;;;;

&title(Corridors)
Both corridors are three stories tall and may contain trial spawners of any category (except breeze) as well as vaults, [decorated pots](^minecraft:decorated_pot), [candles](^minecraft:candle) and [tripwire](https://minecraft.wiki/w/Tripwire) traps. The length of the corridor can vary in multiples of four segments. Each segment may contain a side [copper door](^minecraft:copper_door) from any of the floors connecting to a combat chamber through hallways.

;;;;;

&title(Atrium)
The atrium is a tall, open room connecting the entrance chamber to the first corridor. It features a grand staircase leading down to a fountain, and two large reliefs on the walls have the images of either a [breeze](^minecraft:breeze), [bogged](^minecraft:bogged), [spider](https://minecraft.wiki/w/Spider), or spiral. An [ominous vault](^minecraft:ominous_vault) can be found high above the grand staircase.

;;;;;

![Atrium](minecraft:textures/gui/image/trial_chambers_atrium.png,fit)

An atrium inside the trial chambers.

;;;;;

&title(Hallways)
Small hallways branch off from the main corridors that may lead to additional combat chambers.

;;;;;

&title(Intersections)
There are three types of intersections, which connect the two corridors with a combat chamber and feature an area with multiple beds.

;;;;;

&title(Chambers)
There are a variety of combat chambers, each containing multiple trial spawners, vaults, an ominous vault, and empty chests near each possible entrance. Most chambers have several [dispensers](https://minecraft.wiki/w/Dispenser) along the walls triggered by an [oak button](https://minecraft.wiki/w/Oak_button).

;;;;;

![Chamber](minecraft:textures/gui/image/trial_chambers_chamber.png,fit)

One of various chambers in the trial chambers.

;;;;;

&title(Loot)
Loot is available from [vaults](^minecraft:vault), [chests](https://minecraft.wiki/w/Chest), [barrels](https://minecraft.wiki/w/Barrel), [dispensers](https://minecraft.wiki/w/Dispenser), and [decorated pots](^minecraft:decorated_pot) from within the chambers. Players who defeat a trial spawner each receive rewards; this loot scales depending on the amount of people who defeat the trial spawner.